# Carbon system squad support and maintenance

<!-- prettier-ignore-start -->
<!-- START doctoc generated TOC please keep comment here to allow auto update -->
<!-- DON'T EDIT THIS SECTION, INSTEAD RE-RUN doctoc TO UPDATE -->
## Table of Contents

- [Overview](#overview)
  - [What does "ongoing support" mean regarding GitHub?](#what-does-ongoing-support-mean-regarding-github)
  - [What does "ongoing support" mean regarding Slack?](#what-does-ongoing-support-mean-regarding-slack)
  - [What repositories do we support?](#what-repositories-do-we-support)
- [Issues](#issues)
  - [Types of issues](#types-of-issues)
  - [Triaging a new issue](#triaging-a-new-issue)
  - [Triage Process](#triage-process)
    - [type: bug 🐛 & type: a11y ♿](#type-bug---type-a11y-)
    - [type: question ❓](#type-question-)
    - [type: enhancement 💡](#type-enhancement-)
  - [Severity](#severity)
  - [Project](#project)
  - [Other labels](#other-labels)
  - [Alerting a team or subject matter expert](#alerting-a-team-or-subject-matter-expert)
- [Pull requests](#pull-requests)
  - [WIP, RFC, and Draft pull requests](#wip-rfc-and-draft-pull-requests)
  - [Pull requests with failing tests or merge conflicts](#pull-requests-with-failing-tests-or-merge-conflicts)
  - [Pull Request Reviews](#pull-request-reviews)

<!-- END doctoc generated TOC please keep comment here to allow auto update -->
<!-- prettier-ignore-end -->

## Overview

Ongoing support for the latest version Carbon and the previous version (which
will be prioritized in that order)

Whether you are triaging new issues in GitHub or responding to Slack threads in
our support channels, here are some responses that can help get the conversation
started in case you get stuck.

- “Could you share more about what you’ve already tried?”
- “Can you share more about your usecase?”
- “Can you add a repro (reproduction) using Stackblitz?”
- “After searching through [FILL IN RESOURCE HERE], I was able to find this and thought
  it might be helpful... Let me know if that works.”

### What does "ongoing support" mean regarding GitHub?

- Incoming pull requests (code review, initial communication, ongoing
  discussion, rejection or merge) from the maintainer team and the community (in
  that order).
- Triage
  [new issues](https://github.com/orgs/carbon-design-system/projects/39/views/6)
  on your support day.
- Designers triage design issues and developers triage dev issues.
- Does not include feature enhancements or new feature requests

### What does "ongoing support" mean regarding Slack?

- A minimum of twice per day that maintainers monitor #carbon-design-system and
  #carbon-react Slack support channels and respond to questions. Help our users
  find solutions to their problems.
- The goal is to _respond_ to every thread on your day.
- Go into threads where members of the community answer a question and validate
  the person in the community that answered it by adding an emoji or response
  reiterating the answer and acknowledging the community member.
- Use discretion to respond to applicable threads. Lean on the maintainer team's
  private #carbon-support channel to look for subject matter experts when a
  question goes beyond your skillset. When you ask in this channel, take a leap
  of faith in your skills and propose a response, such as, "This is how I want
  to respond ... YOUR REPLY HERE". Follow the question by practicing humility,
  "How far off am I"? "What am I missing"? Remember, you're acting as an
  advocate for the person who originally asked the question. Respresent their
  needs to the best of your ability.
- If a question is Carbon-related, but not necessarily related to the core
  components, route the person to the correct Slack channel where they might
  receive support.
  - [ibmproducts-pal-dev](https://ibm.enterprise.slack.com/archives/C013ZTX0N6B)
  - [ibmproducts-pal](https://ibm.enterprise.slack.com/archives/CQGR0HC05)
  - [carbon-ng](https://ibm.enterprise.slack.com/archives/CBZC0LM2N)
  - [carbon-for-cloud](https://ibm.enterprise.slack.com/archives/C0603NZDXRD)
  - [carbon-charts](https://ibm.enterprise.slack.com/archives/CCA7L4MS9)
  - [carbon-for-ibm-dotcom](https://ibm.enterprise.slack.com/archives/C2PLX8GQ6)
  - [carbon-web-components](https://ibm.enterprise.slack.com/archives/CL83LMKSA)
  - [carbon-wg-typescript](https://ibm.enterprise.slack.com/archives/C03C8VASVED)

### Configuring the GitHub Slack integration

`/github subscribe carbon-design-system/carbon`

For additional guidance checkout their
[docs](https://github.com/integrations/slack).

### What repositories do we support?

- carbon-design-system/carbon
- carbon-design-system/carbon-website
- carbon-design-system/carbon-design-kit

## Issues

When our users want to submit a new issues to one of our repositories they're
presented with the option to select from one of four templates. These templates
ask a series of specific questions that make first-aid and triage go smoothly.
They help us help them.

_If the user hasn't taken the time to fill out one of our templates feel free to
ask them to do so. Typically you'll need at least a good description of the
problem, a walkthrough of how to recreate the problem and a minimal test case to
observe the problem happening. That last one can be a real sticking point, but
there's lots of work to do and many many issues to triage — the onus is on them
to define the issue their having._

### Types of issues

Using these templates also helps Project-Bot automatically move issues and new
pull requests to the right workstreams by auto labeling the issues according to
the template type. There are three types of issues the maintainer team is
concerned with:

- type: question ❓
- type: bug 🐛
- type: enhancement 💡

In addition to the types above, the issue may also fit one or more of the
following types of issues based on the work being performed.

- type: a11y ♿
- type: docs 📖
- type: infrastructure 🤖

### Triaging a new issue

Triage is the process of determining the severity and priority of issues _as
they come in_. We need to make sure we know how serious a problem is and how
quickly it should be addressed.

### Triage Process

For the different types of issues, we have created the process to triaging each
one so that they can be moved into our Backlog.

#### type: bug 🐛

_Process to triaged_

<details>

<summary>Is there a duplicate issue?</summary>

We receive enough duplicate issues that it is always a good idea to check before
moving on in the triage process. We have issues related to accessibility that
catalogue multiple problems so be sure to check especially with incoming
accessibility problems.

If you find a duplicate, comment to the author, label it as a duplicate, and
close the issue.

</details>

<details>

<summary>Is it actually a bug report?</summary>

Sometimes people mark their issues as a bug when in reality, they are an
enhancement request or a question.

If you find this to be the case, remove the bug label, add the appropriate
label, and then follow the directions in that section.

</details>

<details>
<summary>Did they fill out the issue template?</summary>

The most important part of the issue template is the "steps to reproduce"
section, if the author didn't provide that (and reproduction isn't obvious)
comment asking for reproduction and other relevant details not filled out in the
template.

</details>

<details>
<summary>Can you reproduce the problem?</summary>

If you can reproduce the problem, proceed to label what component it affects,
what role it applies to (design, dev, both), assess the impact and severity
based on the guides below, and label any additional relevant metadata such as
browser or version info.

</details>

After all that, move the issue to the backlog and then you're done! 🎉

#### type: question ❓

_Process to triaged_

<details>
<summary> Is it actually a feature request or bug?</summary>

This happens from time to time so it's always a good idea to make sure they are
asking a question and not really asking for a new feature or addressing a bug.
If they are, remove the question label, label as a `type: enhancement 💡` or
`type: bug 🐛` , and follow the instructions for feature enhancement issues.

</details>

<details>
<summary>Is there a duplicate question?</summary>

We tend to recieve more questions through Slack than through GitHub so with any
incoming question issues, search in both places to see if it has already been
answered. If you can find an answer, point the author to where they can find it
and close the issue.

</details>

<details>
<summary>Can you answer the question?</summary>

If you can answer the question immediately then great! Answer it and wait for
the author to communicate that it did in fact answer what they were asking. If
they don't respond within a week, feel free to close this issue.

</details>
<details>
<summary>Can't answer the question?</summary>

If you can't immediately answer the question, that's fine! The main thing here
is to get the ball rolling so the question can be answered. To do this, You can
post the question in the `carbon-support` Slack channel or `@` someone who you
think has relevant information, in the issue itself or on Slack. Also make sure
to tag the question with any appropriate labels.

</details>

As soon as you've started the process of getting the question answered, you can
move the issue to the backlog! 🎉

#### type: enhancement 💡

_Process to triaged_

<details>
<summary>Does the feature already exist or can be accomplished with existing code?</summary>

Certain components are more configurable than others so it's worth checking if
they can add the functionality they want without it being added to carbon core.
It's also possible that the feature already exists and they just don't know
about it yet. If that is the case, comment with the solution and close the
issue.

</details>
<details>
<summary>Is this a duplicate suggestion?</summary>

Like with the other types of issues, make sure that there isn't already a
proposal for the feature the author is suggesting. If there is, comment with the
link to the duplicate proposal, label as a duplicate, and close the issue.

</details>
<details>
<summary>Did they fill out the issue template?</summary>

After this step, the request will become a proposal so it's necessary that they
filled out all of the issue template. If they haven't, comment asking for the
missing info.

</details>

If they have filled out the template or they have responded with the missing
info, label the issue as an open proposal, label any relevant metadata, and move
the issue to the icebox pipeline! 🎉

The journey of a feature request can be a long and arduous process, depending on
the ask. Checkout the flow chart to see the path a given feature might take.

```mermaid
flowchart TD
    A[Received] --> B[Does it align with the maintainer team's <br />guiding principles for building a design system at IBM?]
    B -->|No| C[Closed]
    B -->|Yes| D[Is it supporting a PAL in the DSAG?]
    D -->|No| E[Is it suporting a PAL not in the DSAG?]
    E -->|No| F[Is it supporting an IBM product without a PAL?]
    F -->|No| G[Is it supporting a non-IBM offering that uses Carbon?]
    G -->|No| C[Closed]
    D & E & F & G -->|Yes| H([Great! Your request has now been labeled as an `open` proposal. <br />Now we will determine who will be working on this and when.])
    H --> I[Is this a concept/idea?]
    H --> J[Is this a fully fleshed out design spec <br /> or code implementation?]
    I -->|Yes| K[Are you able to dedicate design or <br /> engineering resources to bring this to production?]
    I <--> |No|J
    K -->|No| L[Does your request have a low level of effort or a high business impact?]
    L -->|No| C[Closed]
    J & K & L -->|Yes| M([Your request has been labeled as an `accepted` <br />proposal and has been added to our Icebox and is <br />being prioritized against competing workstreams])
    M --> N([Labeled with `Community Contribution` <br /> on GH. Looking for contributions])
    M --> O([Added to maintainer team's roadmap <br /> and backlog for refinement])
    N & O --> storm((Design Crits, Code Reviews,<br /> CAG, DSAG meetings, <br /> Office hours when needed))
    storm --> ide1
    subgraph ide1 [Evaluate against a definition of done]
    P[Storybook]
    Q[Tests]
    R[Code]
    S[Final design spec]
    T[Website docs]
    U[Kit tooling]
    end
    ide1 -->|Yes| C[Closed]

    style storm fill:#6929c4,stroke:#f66,stroke-width:2px,color:#fff,stroke-dasharray: 5 5
    style A fill:#198038,stroke:#fff,stroke-width:2px,color:#fff
    style C fill:#da1e28,stroke:#000,stroke-width:2px,color:#fff
    style H fill:#198038,stroke:#fff,stroke-width:2px,color:#fff
    style M fill:#198038,stroke:#fff,stroke-width:2px,color:#fff
```

### Definitions

Guiding principles -
https://carbondesignsystem.com/all-about-carbon/what-is-carbon/#our-guiding-principles

DSAG - The Design System Adoption Guild is an expansive group of designers and
developers all aligned on the mission of delivering amazing experiences in the
IBM Products organization. You can learn more about the guild
[here](https://pages.github.ibm.com/cdai-design/pal/contributing/contribution-framework/intent).

PAL - Pattern & Asset Library. These are the local systems around IBM that
extend our core components to fit their desired business need.

CAG - Carbon Accessibility Guild. A once a sprint meeting where the Carbon team
gets together with the Accessiblity team. Our components and patterns are
reviewed and made more accessible.

Design crit - A once a sprint meeting led by Carbon designers to review patterns
and artifacts with the intent of eliciting feedback.

Office hours - A once a sprint meeting hosted by the Carbon team to answer
questions, debug, problem-solve, and learn from the community.
[Link to add to your calendar](https://ec.yourlearning.ibm.com/w3/series/10289694?layout=grid).

Low level of effort - A small change to a component that might take a sprint or
less. Little-to-no design or dev resources are needed to flesh out the proposal.

High business impact - The request may not have all the pieces ready to begin
working on it, but the maintainer team is able to see the high degree of
business impact that the feature will bring with future research done.

### Severity

|                                 Level                                 |                                                             Description                                                             | Kit                                                                                                              | Docs                                                                                                                                                                    | Code                                                                                                             | Release                                                                                                                                                                          |
| :-------------------------------------------------------------------: | :---------------------------------------------------------------------------------------------------------------------------------: | ---------------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| https://github.com/carbon-design-system/carbon/labels/severity%3A%201 | Affects major functionality. Blocks users from completing tasks, exposes intellectual property or damages the brand. No workaround. | The kit is has major functionality defects, designers can’t design and there is no workaround                    | The documentation damages the brand or exposes intellectual property.                                                                                                   | The code has major functionality defects, breaking builds and can’t be worked around.                            | If the problem is in production, it must be fixed as soon as possible in a patch.                                                                                                |
| https://github.com/carbon-design-system/carbon/labels/severity%3A%202 |                     Affects major functionality. Does not block users from completing tasks. Has a workaround.                      | The kit has a major functionality defect, but it doesn't block users from completing tasks. It has a workaround. | The documentation is wrong or missing major details. It conflicts with what we are saying in another part of the system.                                                | The code has a major functionality defect, but it doesn't block users from completing tasks. It has a workaround | A release will be moved into Production with defects at this severity level included. These defects will have priority in future sprints to be resolved ASAP.                    |
| https://github.com/carbon-design-system/carbon/labels/severity%3A%203 |                     Affects minor functionality. Does not block users from completing tasks. Has a workaround.                      | The kit has a minor functionality defect. It doesn't block users from completing tasks. Has a workaround.        | The documentation is mis-leading, somewhat true, missing minor details, or grammatically incorrect. It doesn't present conflicts with other parts of the design system. | The code has a minor functionality defect. It doesn’t block users from completing tasks. Has a workaround.       | A release will be moved into Production with defects at this severity level included. These defects will have priority in future sprints after sev2’s.                           |
| https://github.com/carbon-design-system/carbon/labels/severity%3A%204 |                                        Unrelated to a user task. Does not need a workaround.                                        | Unrelated to a user task. Does not need a workaround.                                                            | Unrelated to a user task. Content has a typo.                                                                                                                           | Unrelated to a user task. Does not need a workaround.                                                            | A release will be moved into Production with defects at this severity level included. These will often not be addressed by the maintainer team as a priority in future releases. |

Workarounds can be described as either of the following:

1. A workaround within the ux of a component. e.g. A MultiSelect item is not
   selected when clicking on the _icon_, but is still selected when clicking on
   the _text_.

2. A workaround within the implementation of a component. e.g. A `formatDate`
   function is not working, but there is an `onKeyDown` prop that can be used
   instead to format the date on every keystroke.

If either of these types of workarounds are available, the bug will be
classified as
https://github.com/carbon-design-system/carbon/labels/severity%3A%203 or
https://github.com/carbon-design-system/carbon/labels/severity%3A%204

These can be difficult (and vague!) concepts to wrap your head around. So here's
a handy flow chart to guide you through assigning issue severity:

```mermaid
graph TD
    A[There is a bug!] --> B[Can the user/designer/developer </br> still complete the task?]
    B -->|No| C[Is there a workaround?]
    B -->|Yes| D[Is there a workaround?]
    C -->|No| E[Is this major enough to need an immediate fix?*]
    C -->|Yes| Sev3([Severity: 3])
    E -->|No| Sev2([Severity: 2])
    E -->|Yes| Sev1([Severity: 1])
    D -->|Yes| Sev3
    D -->|Workaround not needed| Sev4([Severity: 4])
    B -->|Unrelated to user task| Sev4
```

> \* Is this major enough to need an immediate fix?

Clearly marking what qualifies as being "major enough" to warrant an immediate
fix is difficult. In general, you'll know these when you see them.

Here are some primary determining factors:

- A large number of projects (10+) impacted by an issue
- The degree to which something is broken (being unable to complete foundational
  tasks like clicking a button or opening a dropdown, for instance)

Also consider the response a
https://github.com/carbon-design-system/carbon/labels/severity%3A%201 issue
requires, and evaluate it against the bug:

- The response must be swift. When a
  https://github.com/carbon-design-system/carbon/labels/severity%3A%201 issue
  comes in, someone from the team must drop all current work and be immediately
  reassigned to address the issue.
- In the worst circumstances, this person may immediately revert a change from a
  previous release.
- It's likely a patch must be published once the fix or revert is in - the item
  can not wait to go out with the next scheduled release.
- We may need to publish a
  [postmortem](https://github.com/carbon-design-system/carbon/tree/main/docs/postmortems)
  identifying what happened and why, with a plan of how we intend to prevent it
  from happening again.

Due to this high threshold and intensity of response,
https://github.com/carbon-design-system/carbon/labels/severity%3A%201 issues
should be infrequent and should not be open for a long period of time.

For the vast majority of bugs that have invalid and blocking behavior with no
workaround, a
https://github.com/carbon-design-system/carbon/labels/severity%3A%202 or lower
is more appropriate.

After applying the severity label, be sure to also apply the appropriate role to
the issue. Either `role: dev 🤖` or `role: design :pencil2:`, depending on which
discipline should be working on it.

### Project

After assigning the role and severity, be sure to apply the correct categories
in the GitHub Project:

- Status
  - Triage - Issues that need triaging
  - Needs Refined - Issues that will be worked on in future sprints, but need to
    be broken down into smaller chunks and discussed.
  - Needs a11y review - Issues that need to be brought to the Carbon
    Accessibility Guild for further refinement and clarity.
  - Backlog - Issues that have been refined move into the Backlog, where they
    will be sized and assigned for a future sprint.
  - In progress - Issues that are being actively worked on in a given sprint.
  - Area - The part of the system that the issue effects.
  - Role - The discipline that will take the lead and deliver the issue to
    completion.

### Other labels

There is a large collection of labels that can help communicate the nature of an
issue at a glance to developers and designers. Here's a few that you might add
that can be particularly helpful:

- v10 - any issue or question pertaining to legacy versions of Carbon Components
  should be tagged v10
- good first issue 👋 - these issues don't require a deep knowledge or
  understanding of our code base and would be great for someone looking to help
  out for the first time with some code

### Alerting a team or subject matter expert

Sometimes an issue comes in that is highly technical or about subject matter
you're unfamiliar with. Nothing wrong with that! Using GitHub ping system you
can alert specific sub-teams on Carbon:

- @carbon-design-system/design
- @carbon-design-system/developers
- @carbon-design-system/ibma

Using any of these @'s in a comment will send notifications to members of those
sub-teams. Typically a subject matter expert from that team will then take over.
You can also @username anyone Carbon's team if you specifically know someone who
has experience with a particular component or issue.

## Pull requests

A good turn around time on pull requests to Carbon's core repositories looks
professional and encourages our users to contribute and work with us to solve
further problems in the future. Shepherding pull requests to merged status isn't
typically _as complex_ as issue triage/tracking, but it's equally important!

### WIP, RFC, and Draft pull requests

If the pull request is a WIP (work in progress), RFC (request for comment), or
Draft then it can be moved to the appropriate swimlane. There are usually a fair
few of these active at a time and don't need the same regard as an _external_
pull requests, but they can be helpful to reference when a Work In Progress pull
request addresses an issue and the maker of that issue asks for a status report
or update (a common occurrence).

### Pull requests with failing tests or merge conflicts

When a new pull request comes in check and make sure our continuous integration
system (Circle CI) doesn't have any failing tests or merge conflicts, if it does
label it accordingly. Then politely ask the pull request maker to fix it.

### Pull Request Reviews

If you notice a pull request languishing without a review for too long. Post in
the carbon-core/carbon-devs channel asking for a review. Ideally pull requests
should have a three business day turn around time on reviews or requested
changes.
