# Namespaced exports

<!-- START doctoc generated TOC please keep comment here to allow auto update -->
<!-- DON'T EDIT THIS SECTION, INSTEAD RE-RUN doctoc TO UPDATE -->

## Table of Contents

- [Overview](#overview)
- [Process](#process)
- [Changes:](#changes)

<!-- END doctoc generated TOC please keep comment here to allow auto update -->

## Overview

In v10.x there were a few exported components that were only exposed under the
namespace of another component. These have been deprecated, and a new export has
been made available for each so these can be imported directly. In v11.x the
namespaced exports will be removed.

## Process

1. Update imports for the components listed in the table below.

```diff
- import { TextInput } from 'carbon-components-react';
+ import { PasswordInput } from 'carbon-components-react';
```

2. Update usages of the components listed in the table below, they no longer
   need the namespace

```diff
- <TextInput.PasswordInput/>
+ <PasswordInput/>
```

## Changes:

| v10.x                               | v11.x                     |
| ----------------------------------- | ------------------------- |
| `TextInput.ControlledPasswordInput` | `ControlledPasswordInput` |
| `TextInput.PasswordInput`           | `PasswordInput`           |
| `MultiSelect.Filterable`            | `FilterableMultiSelect`   |
