/**
 * Copyright IBM Corp. 2016, 2023
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import * as Carbon from '../index';

describe('Carbon Components React', () => {
  it('can be imported using the correct path', () => {
    expect(typeof Carbon).toBe('object');
  });

  it('should export components', () => {
    expect(Object.keys(Carbon).sort()).toMatchInlineSnapshot(`
      [
        "AILabel",
        "AILabelActions",
        "AILabelContent",
        "AISkeletonIcon",
        "AISkeletonPlaceholder",
        "AISkeletonText",
        "Accordion",
        "AccordionItem",
        "AccordionSkeleton",
        "ActionableNotification",
        "AspectRatio",
        "Breadcrumb",
        "BreadcrumbItem",
        "BreadcrumbSkeleton",
        "Button",
        "ButtonKinds",
        "ButtonSet",
        "ButtonSizes",
        "ButtonSkeleton",
        "ButtonTooltipAlignments",
        "ButtonTooltipPositions",
        "Callout",
        "Checkbox",
        "CheckboxGroup",
        "CheckboxSkeleton",
        "ClassPrefix",
        "ClickableTile",
        "CodeSnippet",
        "CodeSnippetSkeleton",
        "Column",
        "ColumnHang",
        "ComboBox",
        "ComboButton",
        "ComposedModal",
        "ComposedModalPresence",
        "ContainedList",
        "ContainedListItem",
        "Content",
        "ContentSwitcher",
        "ControlledPasswordInput",
        "Copy",
        "CopyButton",
        "DangerButton",
        "DataTable",
        "DataTableSkeleton",
        "DatePicker",
        "DatePickerInput",
        "DatePickerSkeleton",
        "DefinitionTooltip",
        "DismissibleTag",
        "Dropdown",
        "DropdownSkeleton",
        "ErrorBoundary",
        "ErrorBoundaryContext",
        "ExpandableSearch",
        "ExpandableTile",
        "FeatureFlags",
        "FileUploader",
        "FileUploaderButton",
        "FileUploaderDropContainer",
        "FileUploaderItem",
        "FileUploaderSkeleton",
        "Filename",
        "FilterableMultiSelect",
        "FlexGrid",
        "FluidComboBox",
        "FluidComboBoxSkeleton",
        "FluidDatePicker",
        "FluidDatePickerInput",
        "FluidDatePickerSkeleton",
        "FluidDropdown",
        "FluidDropdownSkeleton",
        "FluidForm",
        "FluidMultiSelect",
        "FluidMultiSelectSkeleton",
        "FluidNumberInput",
        "FluidNumberInputSkeleton",
        "FluidPasswordInput",
        "FluidSearch",
        "FluidSearchSkeleton",
        "FluidSelect",
        "FluidSelectSkeleton",
        "FluidTextArea",
        "FluidTextAreaSkeleton",
        "FluidTextInput",
        "FluidTextInputSkeleton",
        "FluidTimePicker",
        "FluidTimePickerSelect",
        "FluidTimePickerSkeleton",
        "Form",
        "FormContext",
        "FormGroup",
        "FormItem",
        "FormLabel",
        "GlobalTheme",
        "Grid",
        "GridSettings",
        "HStack",
        "Header",
        "HeaderContainer",
        "HeaderGlobalAction",
        "HeaderGlobalBar",
        "HeaderMenu",
        "HeaderMenuButton",
        "HeaderMenuItem",
        "HeaderName",
        "HeaderNavigation",
        "HeaderPanel",
        "HeaderSideNavItems",
        "Heading",
        "IconButton",
        "IconButtonKinds",
        "IconSkeleton",
        "IconSwitch",
        "IconTab",
        "IdPrefix",
        "InlineLoading",
        "InlineNotification",
        "Layer",
        "Link",
        "ListItem",
        "Loading",
        "Menu",
        "MenuButton",
        "MenuItem",
        "MenuItemDivider",
        "MenuItemGroup",
        "MenuItemRadioGroup",
        "MenuItemSelectable",
        "Modal",
        "ModalBody",
        "ModalFooter",
        "ModalHeader",
        "ModalPresence",
        "ModalWrapper",
        "MultiSelect",
        "NotificationActionButton",
        "NotificationButton",
        "NumberInput",
        "NumberInputSkeleton",
        "OperationalTag",
        "OrderedList",
        "OverflowMenu",
        "OverflowMenuItem",
        "Pagination",
        "PaginationNav",
        "PaginationSkeleton",
        "PasswordInput",
        "Popover",
        "PopoverContent",
        "PrefixContext",
        "PrimaryButton",
        "ProgressBar",
        "ProgressIndicator",
        "ProgressIndicatorSkeleton",
        "ProgressStep",
        "RadioButton",
        "RadioButtonGroup",
        "RadioButtonSkeleton",
        "RadioTile",
        "Row",
        "Search",
        "SearchSkeleton",
        "SecondaryButton",
        "Section",
        "Select",
        "SelectItem",
        "SelectItemGroup",
        "SelectSkeleton",
        "SelectableTag",
        "SelectableTile",
        "SideNav",
        "SideNavDetails",
        "SideNavDivider",
        "SideNavFooter",
        "SideNavHeader",
        "SideNavIcon",
        "SideNavItem",
        "SideNavItems",
        "SideNavLink",
        "SideNavLinkText",
        "SideNavMenu",
        "SideNavMenuItem",
        "SideNavSwitcher",
        "SkeletonIcon",
        "SkeletonPlaceholder",
        "SkeletonText",
        "SkipToContent",
        "Slider",
        "SliderSkeleton",
        "Stack",
        "StaticNotification",
        "StructuredListBody",
        "StructuredListCell",
        "StructuredListHead",
        "StructuredListInput",
        "StructuredListRow",
        "StructuredListSkeleton",
        "StructuredListWrapper",
        "Switch",
        "Switcher",
        "SwitcherDivider",
        "SwitcherItem",
        "Tab",
        "TabContent",
        "TabList",
        "TabListVertical",
        "TabPanel",
        "TabPanels",
        "Table",
        "TableActionList",
        "TableBatchAction",
        "TableBatchActions",
        "TableBody",
        "TableCell",
        "TableContainer",
        "TableDecoratorRow",
        "TableExpandHeader",
        "TableExpandRow",
        "TableExpandedRow",
        "TableHead",
        "TableHeader",
        "TableRow",
        "TableSelectAll",
        "TableSelectRow",
        "TableSlugRow",
        "TableToolbar",
        "TableToolbarAction",
        "TableToolbarContent",
        "TableToolbarMenu",
        "TableToolbarSearch",
        "Tabs",
        "TabsSkeleton",
        "TabsVertical",
        "Tag",
        "TagSkeleton",
        "TextArea",
        "TextAreaSkeleton",
        "TextInput",
        "TextInputSkeleton",
        "Theme",
        "ThemeContext",
        "Tile",
        "TileAboveTheFoldContent",
        "TileBelowTheFoldContent",
        "TileGroup",
        "TimePicker",
        "TimePickerSelect",
        "ToastNotification",
        "Toggle",
        "ToggleSkeleton",
        "ToggleSmallSkeleton",
        "Toggletip",
        "ToggletipActions",
        "ToggletipButton",
        "ToggletipContent",
        "ToggletipLabel",
        "Tooltip",
        "TreeNode",
        "TreeView",
        "UnorderedList",
        "VStack",
        "preview_FeatureFlags",
        "preview_Layout",
        "preview_LayoutDirection",
        "preview_OverflowMenuV2",
        "preview_PageSelector",
        "preview_Pagination",
        "preview_Text",
        "preview_TextDirection",
        "preview__AiSkeletonIcon",
        "preview__AiSkeletonPlaceholder",
        "preview__AiSkeletonText",
        "preview__ChatButton",
        "preview__ChatButtonSkeleton",
        "preview__Dialog",
        "preview__FluidComboBox",
        "preview__FluidComboBoxSkeleton",
        "preview__FluidDatePicker",
        "preview__FluidDatePickerInput",
        "preview__FluidDatePickerSkeleton",
        "preview__FluidDropdown",
        "preview__FluidDropdownSkeleton",
        "preview__FluidMultiSelect",
        "preview__FluidMultiSelectSkeleton",
        "preview__FluidNumberInput",
        "preview__FluidNumberInputSkeleton",
        "preview__FluidSearch",
        "preview__FluidSearchSkeleton",
        "preview__FluidSelect",
        "preview__FluidSelectSkeleton",
        "preview__FluidTextArea",
        "preview__FluidTextAreaSkeleton",
        "preview__FluidTextInput",
        "preview__FluidTextInputSkeleton",
        "preview__FluidTimePicker",
        "preview__FluidTimePickerSelect",
        "preview__FluidTimePickerSkeleton",
        "preview__IconIndicator",
        "preview__PageHeader",
        "preview__ShapeIndicator",
        "preview__Slug",
        "preview__SlugActions",
        "preview__SlugContent",
        "preview_useFeatureFlag",
        "preview_useFeatureFlags",
        "preview_useLayoutDirection",
        "unstable_FeatureFlags",
        "unstable_Layout",
        "unstable_LayoutDirection",
        "unstable_OverflowMenuV2",
        "unstable_PageSelector",
        "unstable_Pagination",
        "unstable_Text",
        "unstable_TextDirection",
        "unstable__AiSkeletonIcon",
        "unstable__AiSkeletonPlaceholder",
        "unstable__AiSkeletonText",
        "unstable__ChatButton",
        "unstable__ChatButtonSkeleton",
        "unstable__FluidComboBox",
        "unstable__FluidComboBoxSkeleton",
        "unstable__FluidDatePicker",
        "unstable__FluidDatePickerInput",
        "unstable__FluidDatePickerSkeleton",
        "unstable__FluidDropdown",
        "unstable__FluidDropdownSkeleton",
        "unstable__FluidMultiSelect",
        "unstable__FluidMultiSelectSkeleton",
        "unstable__FluidNumberInput",
        "unstable__FluidNumberInputSkeleton",
        "unstable__FluidSearch",
        "unstable__FluidSearchSkeleton",
        "unstable__FluidSelect",
        "unstable__FluidSelectSkeleton",
        "unstable__FluidTextArea",
        "unstable__FluidTextAreaSkeleton",
        "unstable__FluidTextInput",
        "unstable__FluidTextInputSkeleton",
        "unstable__FluidTimePicker",
        "unstable__FluidTimePickerSelect",
        "unstable__FluidTimePickerSkeleton",
        "unstable__IconIndicator",
        "unstable__PageHeader",
        "unstable__ShapeIndicator",
        "unstable__Slug",
        "unstable__SlugActions",
        "unstable__SlugContent",
        "unstable_useFeatureFlag",
        "unstable_useFeatureFlags",
        "unstable_useLayoutDirection",
        "useContextMenu",
        "useFeatureFlag",
        "useFeatureFlags",
        "useIdPrefix",
        "useLayer",
        "usePrefersDarkScheme",
        "usePrefix",
        "useTheme",
        "validateNumberSeparators",
      ]
    `);
  });
});
