/**
 * Copyright IBM Corp. 2020, 2023
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

/**
 * Icon Button size.
 */
export enum ICON_BUTTON_SIZE {
  /**
   * Small size.
   */
  SMALL = 'sm',

  /**
   * Medium size.
   */
  MEDIUM = 'md',

  /**
   * Large size.
   */
  LARGE = 'lg',
}

/**
 * Icon Button Tooltip alignment.
 */
export enum ICON_BUTTON_TOOLTIP_ALIGNMENT {
  /**
   * Align the top position for the tooltip content.
   */
  TOP = 'top',

  /**
   * Align the top-left position for the tooltip content.
   */
  TOP_LEFT = 'top-left',

  /**
   * Align the top right position for the tooltip content.
   */
  TOP_RIGHT = 'top-right',

  /**
   * Align the bottom position for the tooltip content.
   */
  BOTTOM = 'bottom',

  /**
   * Align the bottom left position for the tooltip content.
   */
  BOTTOM_LEFT = 'bottom-left',

  /**
   * Align the bottom right position for the tooltip content.
   */
  BOTTOM_RIGHT = 'bottom-right',

  /**
   * Align the left position for the tooltip content.
   */
  LEFT = 'left',

  /**
   * Align the right position for the tooltip content.
   */
  RIGHT = 'right',
}
