/**
 * Copyright IBM Corp. 2026
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

/**
 * Size of the pagination nav.
 */
export enum PAGINATION_NAV_SIZE {
  /**
   * Small size.
   */
  SMALL = 'sm',

  /**
   * Medium size.
   */
  MEDIUM = 'md',

  /**
   * Large size.
   */
  LARGE = 'lg',
}

/**
 * Prev/Next button tooltip alignment.
 */
export enum PAGINATION_TOOLTIP_ALIGNMENT {
  /**
   * Aligned to the start.
   */
  START = 'start',

  /**
   * Aligned to the center.
   */
  CENTER = 'center',

  /**
   * Aligned to the end.
   */
  END = 'end',
}

/**
 * Prev/Next button tooltip position.
 */
export enum PAGINATION_TOOLTIP_POSITION {
  /**
   * Positioned on the top.
   */
  TOP = 'top',

  /**
   * Positioned on the right.
   */
  RIGHT = 'right',

  /**
   * Positioned on the bottom.
   */
  BOTTOM = 'bottom',

  /**
   * Positioned on the left.
   */
  LEFT = 'left',
}
