/**
 * Copyright IBM Corp. 2023, 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { LitElement, html } from 'lit';
import { property } from 'lit/decorators.js';
import { carbonElement as customElement } from '../../globals/decorators/carbon-element';
import styles from './header.scss?lit';
import { prefix } from '../../globals/settings';

/**
 * Switcher
 *
 * @element cds-switcher
 */
@customElement(`${prefix}-switcher`)
class CDSSwitcher extends LitElement {
  /**
   * Required props for accessibility label on the underlying menu
   */
  @property({ type: String, attribute: 'aria-label' })
  ariaLabel;

  /**
   * Prop for accessibility labelled by on the underlying menu
   */
  @property({ type: String, attribute: 'aria-labelledby' })
  ariaLabelledBy;

  connectedCallback() {
    if (!this.hasAttribute('role')) {
      this.setAttribute('role', 'list');
    }
    super.connectedCallback();
  }

  render() {
    return html`<slot></slot>`;
  }

  static shadowRootOptions = {
    ...LitElement.shadowRootOptions,
    delegatesFocus: true,
  };

  static styles = styles;
}

export default CDSSwitcher;
